		clear all
		close all
		clc
	 	wcT = 0.495*pi;	wsT = 0.5*pi;  Amax = 0.2;	Amin = 50;	M = 5;
		[Case, wcGT, wsGT, F1e, F2e] = FRM_CASE(wcT, wsT, M);	
		Case
		% Select the A_IIR of the model filter to a small fraction of Amax
		%*****************************
		A_IIR = 0.07; % Typically select Amax/10 or less
		%*******************************
		N = CA_ORDER_Z(wcGT, wsGT, A_IIR, Amin), NG = ceil(N);
		NG = NG+1-rem(NG,2);  % Make order an odd order Cauer filter
		NG
		% Determine the maximal stopband attenuation of the model filter
		Amin_Max = CA_Amin_Z(NG, wcGT, wsGT, A_IIR);
		Amin_comp = -10*log10(1-10^(-Amin_Max/10));
		[G, Z, R_ZEROS, P, wsTnew] = CA_POLES_Z(wcGT, wsGT, A_IIR, Amin_Max, NG);		
		Delta_p = 1-10^(-Amax/10);	Delta_s = 1/10^(Amin/10);		
		figure(1), PLOT_PZ_Z(Z, P)
		% Estimate the  order of the two FIR filters
		AmaxFir = Amax-A_IIR;		x = 10^(AmaxFir/20);
		dc = (x-1)/(x+1);			ds =(1+dc)/10^(Amin/20);
		[NF0, Be, D, W] = HERRMANN_LP_FIR_ORDER([F1e(2), F1e(3)], [dc, ds]);	
		NF0
		[NF1, Be, D, W] = HERRMANN_LP_FIR_ORDER([F2e(2),F2e(3)], [dc, ds]);
		NF1
		% Select
		NF0 = 23; NF1= 23;
		[f0, f1] = FRM_IIR_FIR(F1e, F2e, Delta_p, Delta_s, P, M, NF0, NF1);
	
		MwT = linspace(0,M*pi, 1000); wT = linspace(0,pi,1000);
		%	Determining the magnitude responses of the IIR filter
		[S1num, S1den, S2num, S2den] = SORT_LATTICE_POLES_LP_Z(P);
		[S1, S2] = LATTICE_2_H_Z(S1num, S1den, S2num, S2den, MwT);
		GM = (S2-S1)/2; GcM = (S2+S1)/2;
		H_F0 = ZEROAMW(f0,wT);	H_F1 = ZEROAMW(f1,wT);
		figure(2), subplot(2,1,1)
		PLOT_MAG_Z_dB(wT, GM, pi, 80, '-'), hold on
		PLOT_MAG_Z_dB(wT, H_F0, pi, 80,'H_l_o_w_e_r_B' )
		subplot(2,1,2)
		PLOT_MAG_Z_dB(wT, GcM, pi, 80, '-'), hold on
		PLOT_MAG_Z_dB(wT, H_F1, pi, 80, 'H_u_p_p_e_r_B')
		figure(3)	
		H = GM.*H_F0 + GcM.*H_F1;		% The overall filter
		PLOT_MAG_Z_dB(wT, H, pi, 80, 'H'), hold on	
		axes('position',[0.24 0.5 0.25 0.25]);
		wT = linspace(0, wcT, 1000);	
		[S1, S2] = LATTICE_2_H_Z(S1num, S1den, S2num, S2den, M*wT);	 
		GM = (S2-S1)/2; GcM = (S2+S1)/2;
		H_F0 = ZEROAMW(f0,wT);	H_F1 = ZEROAMW(f1,wT);
		H = GM.*H_F0 + GcM.*H_F1;
		PLOT_MAG_Z_dB2(wT, H, wcT, 0.2, 'H')									
